@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.PeriodicTimerSourceInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RoleSinkInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.PeriodicTimerSourceInfoResponse.Companion.toKotlin as periodicTimerSourceInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RoleSinkInfoResponse.Companion.toKotlin as roleSinkInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PeriodicTimerEventTrigger].
 */
@PulumiTagMarker
public class PeriodicTimerEventTriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeriodicTimerEventTriggerArgs = PeriodicTimerEventTriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeriodicTimerEventTriggerArgsBuilder.() -> Unit) {
        val builder = PeriodicTimerEventTriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PeriodicTimerEventTrigger {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PeriodicTimerEventTrigger(builtJavaResource)
    }
}

/**
 * Trigger details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### TriggerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var periodicTimerEventTrigger = new AzureNative.DataBoxEdge.PeriodicTimerEventTrigger("periodicTimerEventTrigger", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "trigger1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewPeriodicTimerEventTrigger(ctx, "periodicTimerEventTrigger", &databoxedge.PeriodicTimerEventTriggerArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("trigger1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger;
 * import com.pulumi.azurenative.databoxedge.PeriodicTimerEventTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var periodicTimerEventTrigger = new PeriodicTimerEventTrigger("periodicTimerEventTrigger", PeriodicTimerEventTriggerArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("trigger1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:PeriodicTimerEventTrigger trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/triggers/{name}
 * ```
 */
public class PeriodicTimerEventTrigger internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger,
) : KotlinCustomResource(javaResource, PeriodicTimerEventTriggerMapper) {
    /**
     * A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    public val customContextTag: Output<String>?
        get() = javaResource.customContextTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trigger Kind.
     * Expected value is 'PeriodicTimerEvent'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Role Sink information.
     */
    public val sinkInfo: Output<RoleSinkInfoResponse>
        get() = javaResource.sinkInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                roleSinkInfoResponseToKotlin(args0)
            })
        })

    /**
     * Periodic timer details.
     */
    public val sourceInfo: Output<PeriodicTimerSourceInfoResponse>
        get() = javaResource.sourceInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                periodicTimerSourceInfoResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of Trigger
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PeriodicTimerEventTriggerMapper : ResourceMapper<PeriodicTimerEventTrigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger::class == javaResource::class

    override fun map(javaResource: Resource): PeriodicTimerEventTrigger =
        PeriodicTimerEventTrigger(
            javaResource as
                com.pulumi.azurenative.databoxedge.PeriodicTimerEventTrigger,
        )
}

/**
 * @see [PeriodicTimerEventTrigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeriodicTimerEventTrigger].
 */
public suspend fun periodicTimerEventTrigger(
    name: String,
    block: suspend PeriodicTimerEventTriggerResourceBuilder.() -> Unit,
): PeriodicTimerEventTrigger {
    val builder = PeriodicTimerEventTriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeriodicTimerEventTrigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun periodicTimerEventTrigger(name: String): PeriodicTimerEventTrigger {
    val builder = PeriodicTimerEventTriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
