@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.ShareArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.DataPolicy
import com.pulumi.azurenative.databoxedge.kotlin.enums.MonitoringStatus
import com.pulumi.azurenative.databoxedge.kotlin.enums.ShareAccessProtocol
import com.pulumi.azurenative.databoxedge.kotlin.enums.ShareStatus
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AzureContainerInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AzureContainerInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ClientAccessRightArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ClientAccessRightArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RefreshDetailsArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RefreshDetailsArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.UserAccessRightArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.UserAccessRightArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a share on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### SharePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var share = new AzureNative.DataBoxEdge.Share("share", new()
 *     {
 *         AccessProtocol = AzureNative.DataBoxEdge.ShareAccessProtocol.SMB,
 *         AzureContainerInfo = new AzureNative.DataBoxEdge.Inputs.AzureContainerInfoArgs
 *         {
 *             ContainerName = "testContainerSMB",
 *             DataFormat = AzureNative.DataBoxEdge.AzureContainerDataFormat.BlockBlob,
 *             StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1",
 *         },
 *         DataPolicy = AzureNative.DataBoxEdge.DataPolicy.Cloud,
 *         Description = "",
 *         DeviceName = "testedgedevice",
 *         MonitoringStatus = AzureNative.DataBoxEdge.MonitoringStatus.Enabled,
 *         Name = "smbshare",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ShareStatus = "Online",
 *         UserAccessRights = new[]
 *         {
 *             new AzureNative.DataBoxEdge.Inputs.UserAccessRightArgs
 *             {
 *                 AccessType = AzureNative.DataBoxEdge.ShareAccessType.Change,
 *                 UserId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewShare(ctx, "share", &databoxedge.ShareArgs{
 * 			AccessProtocol: pulumi.String(databoxedge.ShareAccessProtocolSMB),
 * 			AzureContainerInfo: &databoxedge.AzureContainerInfoArgs{
 * 				ContainerName:              pulumi.String("testContainerSMB"),
 * 				DataFormat:                 pulumi.String(databoxedge.AzureContainerDataFormatBlockBlob),
 * 				StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1"),
 * 			},
 * 			DataPolicy:        pulumi.String(databoxedge.DataPolicyCloud),
 * 			Description:       pulumi.String(""),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			MonitoringStatus:  pulumi.String(databoxedge.MonitoringStatusEnabled),
 * 			Name:              pulumi.String("smbshare"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ShareStatus:       pulumi.String("Online"),
 * 			UserAccessRights: databoxedge.UserAccessRightArray{
 * 				&databoxedge.UserAccessRightArgs{
 * 					AccessType: pulumi.String(databoxedge.ShareAccessTypeChange),
 * 					UserId:     pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Share;
 * import com.pulumi.azurenative.databoxedge.ShareArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AzureContainerInfoArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.UserAccessRightArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var share = new Share("share", ShareArgs.builder()
 *             .accessProtocol("SMB")
 *             .azureContainerInfo(AzureContainerInfoArgs.builder()
 *                 .containerName("testContainerSMB")
 *                 .dataFormat("BlockBlob")
 *                 .storageAccountCredentialId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1")
 *                 .build())
 *             .dataPolicy("Cloud")
 *             .description("")
 *             .deviceName("testedgedevice")
 *             .monitoringStatus("Enabled")
 *             .name("smbshare")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .shareStatus("Online")
 *             .userAccessRights(UserAccessRightArgs.builder()
 *                 .accessType("Change")
 *                 .userId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Share smbshare /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/shares/{name}
 * ```
 * @property accessProtocol Access protocol to be used by the share.
 * @property azureContainerInfo Azure container mapping for the share.
 * @property clientAccessRights List of IP addresses and corresponding access rights on the share(required for NFS protocol).
 * @property dataPolicy Data policy of the share.
 * @property description Description for the share.
 * @property deviceName The device name.
 * @property monitoringStatus Current monitoring status of the share.
 * @property name The share name.
 * @property refreshDetails Details of the refresh job on this share.
 * @property resourceGroupName The resource group name.
 * @property shareStatus Current status of the share.
 * @property userAccessRights Mapping of users and corresponding access rights on the share (required for SMB protocol).
 */
public data class ShareArgs(
    public val accessProtocol: Output<Either<String, ShareAccessProtocol>>? = null,
    public val azureContainerInfo: Output<AzureContainerInfoArgs>? = null,
    public val clientAccessRights: Output<List<ClientAccessRightArgs>>? = null,
    public val dataPolicy: Output<Either<String, DataPolicy>>? = null,
    public val description: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val monitoringStatus: Output<Either<String, MonitoringStatus>>? = null,
    public val name: Output<String>? = null,
    public val refreshDetails: Output<RefreshDetailsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareStatus: Output<Either<String, ShareStatus>>? = null,
    public val userAccessRights: Output<List<UserAccessRightArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.ShareArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.ShareArgs =
        com.pulumi.azurenative.databoxedge.ShareArgs.builder()
            .accessProtocol(
                accessProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureContainerInfo(
                azureContainerInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientAccessRights(
                clientAccessRights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataPolicy(
                dataPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .monitoringStatus(
                monitoringStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .refreshDetails(refreshDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareStatus(
                shareStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userAccessRights(
                userAccessRights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ShareArgs].
 */
@PulumiTagMarker
public class ShareArgsBuilder internal constructor() {
    private var accessProtocol: Output<Either<String, ShareAccessProtocol>>? = null

    private var azureContainerInfo: Output<AzureContainerInfoArgs>? = null

    private var clientAccessRights: Output<List<ClientAccessRightArgs>>? = null

    private var dataPolicy: Output<Either<String, DataPolicy>>? = null

    private var description: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var monitoringStatus: Output<Either<String, MonitoringStatus>>? = null

    private var name: Output<String>? = null

    private var refreshDetails: Output<RefreshDetailsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareStatus: Output<Either<String, ShareStatus>>? = null

    private var userAccessRights: Output<List<UserAccessRightArgs>>? = null

    /**
     * @param value Access protocol to be used by the share.
     */
    @JvmName("htligxkmevyfpeej")
    public suspend fun accessProtocol(`value`: Output<Either<String, ShareAccessProtocol>>) {
        this.accessProtocol = value
    }

    /**
     * @param value Azure container mapping for the share.
     */
    @JvmName("dsjofipigjndyney")
    public suspend fun azureContainerInfo(`value`: Output<AzureContainerInfoArgs>) {
        this.azureContainerInfo = value
    }

    /**
     * @param value List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("mthabvndxoojhslv")
    public suspend fun clientAccessRights(`value`: Output<List<ClientAccessRightArgs>>) {
        this.clientAccessRights = value
    }

    @JvmName("xfhqyqexvhtdvkfe")
    public suspend fun clientAccessRights(vararg values: Output<ClientAccessRightArgs>) {
        this.clientAccessRights = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("nmxuogtdskdfkomq")
    public suspend fun clientAccessRights(values: List<Output<ClientAccessRightArgs>>) {
        this.clientAccessRights = Output.all(values)
    }

    /**
     * @param value Data policy of the share.
     */
    @JvmName("xkaygtdcgbrkomdq")
    public suspend fun dataPolicy(`value`: Output<Either<String, DataPolicy>>) {
        this.dataPolicy = value
    }

    /**
     * @param value Description for the share.
     */
    @JvmName("rpjushdnlntbyieq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("ixobkrpoaktwijjp")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Current monitoring status of the share.
     */
    @JvmName("uriiususbasmhste")
    public suspend fun monitoringStatus(`value`: Output<Either<String, MonitoringStatus>>) {
        this.monitoringStatus = value
    }

    /**
     * @param value The share name.
     */
    @JvmName("mdjulntqbfpecpnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Details of the refresh job on this share.
     */
    @JvmName("oclxtyfxawkpfmmo")
    public suspend fun refreshDetails(`value`: Output<RefreshDetailsArgs>) {
        this.refreshDetails = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nlguarseolqgtxgl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Current status of the share.
     */
    @JvmName("nxkifqqeapqbxjyl")
    public suspend fun shareStatus(`value`: Output<Either<String, ShareStatus>>) {
        this.shareStatus = value
    }

    /**
     * @param value Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("vseabwpeagccepdh")
    public suspend fun userAccessRights(`value`: Output<List<UserAccessRightArgs>>) {
        this.userAccessRights = value
    }

    @JvmName("xdcjiwjqbyddemng")
    public suspend fun userAccessRights(vararg values: Output<UserAccessRightArgs>) {
        this.userAccessRights = Output.all(values.asList())
    }

    /**
     * @param values Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("fqutpbfnypyhhykb")
    public suspend fun userAccessRights(values: List<Output<UserAccessRightArgs>>) {
        this.userAccessRights = Output.all(values)
    }

    /**
     * @param value Access protocol to be used by the share.
     */
    @JvmName("umedrekkmrklvgwi")
    public suspend fun accessProtocol(`value`: Either<String, ShareAccessProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessProtocol = mapped
    }

    /**
     * @param value Access protocol to be used by the share.
     */
    @JvmName("lrqpbtoxckiwbygv")
    public fun accessProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShareAccessProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessProtocol = mapped
    }

    /**
     * @param value Access protocol to be used by the share.
     */
    @JvmName("loeyqbnsfirhkvrq")
    public fun accessProtocol(`value`: ShareAccessProtocol) {
        val toBeMapped = Either.ofRight<String, ShareAccessProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessProtocol = mapped
    }

    /**
     * @param value Azure container mapping for the share.
     */
    @JvmName("rkkojgaxhkqaijte")
    public suspend fun azureContainerInfo(`value`: AzureContainerInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureContainerInfo = mapped
    }

    /**
     * @param argument Azure container mapping for the share.
     */
    @JvmName("ivruitbnwkfiyseg")
    public suspend fun azureContainerInfo(argument: suspend AzureContainerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureContainerInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureContainerInfo = mapped
    }

    /**
     * @param value List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("xftiyyrodxvswpme")
    public suspend fun clientAccessRights(`value`: List<ClientAccessRightArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAccessRights = mapped
    }

    /**
     * @param argument List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("xnryqquebwkfmgkm")
    public suspend fun clientAccessRights(argument: List<suspend ClientAccessRightArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClientAccessRightArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAccessRights = mapped
    }

    /**
     * @param argument List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("oeewbbnxmwlxrfut")
    public suspend fun clientAccessRights(vararg argument: suspend ClientAccessRightArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClientAccessRightArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientAccessRights = mapped
    }

    /**
     * @param argument List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("sqfirgrkfwjbcjhr")
    public suspend fun clientAccessRights(argument: suspend ClientAccessRightArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClientAccessRightArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clientAccessRights = mapped
    }

    /**
     * @param values List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    @JvmName("qwuihumlraejrqll")
    public suspend fun clientAccessRights(vararg values: ClientAccessRightArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientAccessRights = mapped
    }

    /**
     * @param value Data policy of the share.
     */
    @JvmName("jbcwvjaaofkinsmd")
    public suspend fun dataPolicy(`value`: Either<String, DataPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Data policy of the share.
     */
    @JvmName("pnvcvfdoapfbivcj")
    public fun dataPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Data policy of the share.
     */
    @JvmName("kshppcyoqoofecff")
    public fun dataPolicy(`value`: DataPolicy) {
        val toBeMapped = Either.ofRight<String, DataPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPolicy = mapped
    }

    /**
     * @param value Description for the share.
     */
    @JvmName("wgcvmxtbowysphyy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("rwtlxquddbdbngvw")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Current monitoring status of the share.
     */
    @JvmName("mmyhckvwqdroimvk")
    public suspend fun monitoringStatus(`value`: Either<String, MonitoringStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Current monitoring status of the share.
     */
    @JvmName("smwrohhqeljecowx")
    public fun monitoringStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Current monitoring status of the share.
     */
    @JvmName("opqqelvgipycfmbn")
    public fun monitoringStatus(`value`: MonitoringStatus) {
        val toBeMapped = Either.ofRight<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value The share name.
     */
    @JvmName("xmkcwwfynhexsyic")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Details of the refresh job on this share.
     */
    @JvmName("ensfpnvtipwdfkqw")
    public suspend fun refreshDetails(`value`: RefreshDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshDetails = mapped
    }

    /**
     * @param argument Details of the refresh job on this share.
     */
    @JvmName("mmiligwvqaklllil")
    public suspend fun refreshDetails(argument: suspend RefreshDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = RefreshDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.refreshDetails = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("disktqmyofegrpyb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Current status of the share.
     */
    @JvmName("mwsjmanwtsivsvrl")
    public suspend fun shareStatus(`value`: Either<String, ShareStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareStatus = mapped
    }

    /**
     * @param value Current status of the share.
     */
    @JvmName("trnqyqhnmtbyvklw")
    public fun shareStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShareStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareStatus = mapped
    }

    /**
     * @param value Current status of the share.
     */
    @JvmName("ndaiquqsputfohdv")
    public fun shareStatus(`value`: ShareStatus) {
        val toBeMapped = Either.ofRight<String, ShareStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareStatus = mapped
    }

    /**
     * @param value Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("poganiaopqfeltpj")
    public suspend fun userAccessRights(`value`: List<UserAccessRightArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAccessRights = mapped
    }

    /**
     * @param argument Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("hlebuejiloncbagw")
    public suspend fun userAccessRights(argument: List<suspend UserAccessRightArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserAccessRightArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAccessRights = mapped
    }

    /**
     * @param argument Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("tjcywliwgnykoxrr")
    public suspend fun userAccessRights(vararg argument: suspend UserAccessRightArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserAccessRightArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAccessRights = mapped
    }

    /**
     * @param argument Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("ftmluiajxueyjdrr")
    public suspend fun userAccessRights(argument: suspend UserAccessRightArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserAccessRightArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userAccessRights = mapped
    }

    /**
     * @param values Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    @JvmName("gvhcwptkxkokunub")
    public suspend fun userAccessRights(vararg values: UserAccessRightArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAccessRights = mapped
    }

    internal fun build(): ShareArgs = ShareArgs(
        accessProtocol = accessProtocol,
        azureContainerInfo = azureContainerInfo,
        clientAccessRights = clientAccessRights,
        dataPolicy = dataPolicy,
        description = description,
        deviceName = deviceName,
        monitoringStatus = monitoringStatus,
        name = name,
        refreshDetails = refreshDetails,
        resourceGroupName = resourceGroupName,
        shareStatus = shareStatus,
        userAccessRights = userAccessRights,
    )
}
