@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Host OS supported by the Kubernetes role.
 */
public enum class PlatformType(
    public val javaValue: com.pulumi.azurenative.databoxedge.enums.PlatformType,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.enums.PlatformType> {
    Windows(com.pulumi.azurenative.databoxedge.enums.PlatformType.Windows),
    Linux(com.pulumi.azurenative.databoxedge.enums.PlatformType.Linux),
    ;

    override fun toJava(): com.pulumi.azurenative.databoxedge.enums.PlatformType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.enums.PlatformType): PlatformType = PlatformType.values().first { it.javaValue == javaType }
    }
}
