@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.ClientAccessRightArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.ClientPermissionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The mapping between a particular client IP and the type of access client has on the NFS share.
 * @property accessPermission Type of access to be allowed for the client.
 * @property client IP of the client.
 */
public data class ClientAccessRightArgs(
    public val accessPermission: Output<Either<String, ClientPermissionType>>,
    public val client: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.ClientAccessRightArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.ClientAccessRightArgs =
        com.pulumi.azurenative.databoxedge.inputs.ClientAccessRightArgs.builder()
            .accessPermission(
                accessPermission.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .client(client.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientAccessRightArgs].
 */
@PulumiTagMarker
public class ClientAccessRightArgsBuilder internal constructor() {
    private var accessPermission: Output<Either<String, ClientPermissionType>>? = null

    private var client: Output<String>? = null

    /**
     * @param value Type of access to be allowed for the client.
     */
    @JvmName("ajyknaaflivsvxly")
    public suspend fun accessPermission(`value`: Output<Either<String, ClientPermissionType>>) {
        this.accessPermission = value
    }

    /**
     * @param value IP of the client.
     */
    @JvmName("xbomjngvfmbdvojy")
    public suspend fun client(`value`: Output<String>) {
        this.client = value
    }

    /**
     * @param value Type of access to be allowed for the client.
     */
    @JvmName("pfjqxtyxniechgrf")
    public suspend fun accessPermission(`value`: Either<String, ClientPermissionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPermission = mapped
    }

    /**
     * @param value Type of access to be allowed for the client.
     */
    @JvmName("erngffytjfdmrwcn")
    public fun accessPermission(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClientPermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPermission = mapped
    }

    /**
     * @param value Type of access to be allowed for the client.
     */
    @JvmName("kewrduimpsswyvoh")
    public fun accessPermission(`value`: ClientPermissionType) {
        val toBeMapped = Either.ofRight<String, ClientPermissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessPermission = mapped
    }

    /**
     * @param value IP of the client.
     */
    @JvmName("bkactwqockmhuybr")
    public suspend fun client(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.client = mapped
    }

    internal fun build(): ClientAccessRightArgs = ClientAccessRightArgs(
        accessPermission = accessPermission ?: throw PulumiNullFieldException("accessPermission"),
        client = client ?: throw PulumiNullFieldException("client"),
    )
}
