@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.ComputeResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Compute infrastructure Resource
 * @property memoryInGB Memory in GB
 * @property processorCount Processor count
 */
public data class ComputeResourceArgs(
    public val memoryInGB: Output<Double>,
    public val processorCount: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.ComputeResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.ComputeResourceArgs =
        com.pulumi.azurenative.databoxedge.inputs.ComputeResourceArgs.builder()
            .memoryInGB(memoryInGB.applyValue({ args0 -> args0 }))
            .processorCount(processorCount.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeResourceArgs].
 */
@PulumiTagMarker
public class ComputeResourceArgsBuilder internal constructor() {
    private var memoryInGB: Output<Double>? = null

    private var processorCount: Output<Int>? = null

    /**
     * @param value Memory in GB
     */
    @JvmName("kqjvvdvekvhhhyal")
    public suspend fun memoryInGB(`value`: Output<Double>) {
        this.memoryInGB = value
    }

    /**
     * @param value Processor count
     */
    @JvmName("elqenkqpiioraqgw")
    public suspend fun processorCount(`value`: Output<Int>) {
        this.processorCount = value
    }

    /**
     * @param value Memory in GB
     */
    @JvmName("niywmurmjnqngbac")
    public suspend fun memoryInGB(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryInGB = mapped
    }

    /**
     * @param value Processor count
     */
    @JvmName("tfqhnhpscoemchqc")
    public suspend fun processorCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processorCount = mapped
    }

    internal fun build(): ComputeResourceArgs = ComputeResourceArgs(
        memoryInGB = memoryInGB ?: throw PulumiNullFieldException("memoryInGB"),
        processorCount = processorCount ?: throw PulumiNullFieldException("processorCount"),
    )
}
