@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetFileEventTriggerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name.
 * @property name The trigger name.
 * @property resourceGroupName The resource group name.
 */
public data class GetFileEventTriggerPlainArgs(
    public val deviceName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetFileEventTriggerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetFileEventTriggerPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetFileEventTriggerPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileEventTriggerPlainArgs].
 */
@PulumiTagMarker
public class GetFileEventTriggerPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The device name.
     */
    @JvmName("qdroekvuawrxsbay")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("qniyrekwsimwihdq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("cmteamsbkiftcyvd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFileEventTriggerPlainArgs = GetFileEventTriggerPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
