@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kubernetes role resources
 * @property compute Kubernetes role compute resource
 * @property storage Kubernetes role storage resource
 */
public data class KubernetesRoleResourcesArgs(
    public val compute: Output<KubernetesRoleComputeArgs>,
    public val storage: Output<KubernetesRoleStorageArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleResourcesArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleResourcesArgs =
        com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleResourcesArgs.builder()
            .compute(compute.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storage(storage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KubernetesRoleResourcesArgs].
 */
@PulumiTagMarker
public class KubernetesRoleResourcesArgsBuilder internal constructor() {
    private var compute: Output<KubernetesRoleComputeArgs>? = null

    private var storage: Output<KubernetesRoleStorageArgs>? = null

    /**
     * @param value Kubernetes role compute resource
     */
    @JvmName("aifctgfitpmymrqm")
    public suspend fun compute(`value`: Output<KubernetesRoleComputeArgs>) {
        this.compute = value
    }

    /**
     * @param value Kubernetes role storage resource
     */
    @JvmName("jgfhlaogdbyftnbb")
    public suspend fun storage(`value`: Output<KubernetesRoleStorageArgs>) {
        this.storage = value
    }

    /**
     * @param value Kubernetes role compute resource
     */
    @JvmName("bdoqkdaisfjoxkbl")
    public suspend fun compute(`value`: KubernetesRoleComputeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compute = mapped
    }

    /**
     * @param argument Kubernetes role compute resource
     */
    @JvmName("lpokybtjbjhtyyaa")
    public suspend fun compute(argument: suspend KubernetesRoleComputeArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesRoleComputeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compute = mapped
    }

    /**
     * @param value Kubernetes role storage resource
     */
    @JvmName("dtfbrxmwuraqdxcy")
    public suspend fun storage(`value`: KubernetesRoleStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param argument Kubernetes role storage resource
     */
    @JvmName("nkckpgdxjafqfaqh")
    public suspend fun storage(argument: suspend KubernetesRoleStorageArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesRoleStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storage = mapped
    }

    internal fun build(): KubernetesRoleResourcesArgs = KubernetesRoleResourcesArgs(
        compute = compute ?: throw PulumiNullFieldException("compute"),
        storage = storage,
    )
}
