@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.MetricDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The metric dimension
 * @property sourceName The dimension value.
 * @property sourceType The dimension type.
 */
public data class MetricDimensionArgs(
    public val sourceName: Output<String>,
    public val sourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.MetricDimensionArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.MetricDimensionArgs =
        com.pulumi.azurenative.databoxedge.inputs.MetricDimensionArgs.builder()
            .sourceName(sourceName.applyValue({ args0 -> args0 }))
            .sourceType(sourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricDimensionArgs].
 */
@PulumiTagMarker
public class MetricDimensionArgsBuilder internal constructor() {
    private var sourceName: Output<String>? = null

    private var sourceType: Output<String>? = null

    /**
     * @param value The dimension value.
     */
    @JvmName("vanuwaujineiagoe")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value The dimension type.
     */
    @JvmName("hegcmavofxbsdinn")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The dimension value.
     */
    @JvmName("ggcimevobqlvptyf")
    public suspend fun sourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value The dimension type.
     */
    @JvmName("grutylefdvspmkrd")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): MetricDimensionArgs = MetricDimensionArgs(
        sourceName = sourceName ?: throw PulumiNullFieldException("sourceName"),
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
    )
}
