@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.PeriodicTimerSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Periodic timer event source.
 * @property schedule Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
 * @property startTime The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
 * @property topic Topic where periodic events are published to IoT device.
 */
public data class PeriodicTimerSourceInfoArgs(
    public val schedule: Output<String>,
    public val startTime: Output<String>,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.PeriodicTimerSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.PeriodicTimerSourceInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.PeriodicTimerSourceInfoArgs.builder()
            .schedule(schedule.applyValue({ args0 -> args0 }))
            .startTime(startTime.applyValue({ args0 -> args0 }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeriodicTimerSourceInfoArgs].
 */
@PulumiTagMarker
public class PeriodicTimerSourceInfoArgsBuilder internal constructor() {
    private var schedule: Output<String>? = null

    private var startTime: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
     */
    @JvmName("mhaphxtkwtjfgeig")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
     */
    @JvmName("isaawroowkqipudo")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Topic where periodic events are published to IoT device.
     */
    @JvmName("xxusmgoxngeuqsnt")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
     */
    @JvmName("mfwqnflmuoifwdph")
    public suspend fun schedule(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
     */
    @JvmName("udvbfooysihfmoyj")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Topic where periodic events are published to IoT device.
     */
    @JvmName("xkhnbwaclebcahpr")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): PeriodicTimerSourceInfoArgs = PeriodicTimerSourceInfoArgs(
        schedule = schedule ?: throw PulumiNullFieldException("schedule"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        topic = topic,
    )
}
