@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.RefreshDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Fields for tracking refresh job on the share or container.
 * @property errorManifestFile Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
 * @property inProgressRefreshJobId If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
 * @property lastCompletedRefreshJobTimeInUTC Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
 * @property lastJob Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
 */
public data class RefreshDetailsArgs(
    public val errorManifestFile: Output<String>? = null,
    public val inProgressRefreshJobId: Output<String>? = null,
    public val lastCompletedRefreshJobTimeInUTC: Output<String>? = null,
    public val lastJob: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.RefreshDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.RefreshDetailsArgs =
        com.pulumi.azurenative.databoxedge.inputs.RefreshDetailsArgs.builder()
            .errorManifestFile(errorManifestFile?.applyValue({ args0 -> args0 }))
            .inProgressRefreshJobId(inProgressRefreshJobId?.applyValue({ args0 -> args0 }))
            .lastCompletedRefreshJobTimeInUTC(lastCompletedRefreshJobTimeInUTC?.applyValue({ args0 -> args0 }))
            .lastJob(lastJob?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshDetailsArgs].
 */
@PulumiTagMarker
public class RefreshDetailsArgsBuilder internal constructor() {
    private var errorManifestFile: Output<String>? = null

    private var inProgressRefreshJobId: Output<String>? = null

    private var lastCompletedRefreshJobTimeInUTC: Output<String>? = null

    private var lastJob: Output<String>? = null

    /**
     * @param value Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
     */
    @JvmName("ogfsijksqpohgkjj")
    public suspend fun errorManifestFile(`value`: Output<String>) {
        this.errorManifestFile = value
    }

    /**
     * @param value If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
     */
    @JvmName("tyaloyivifxbxexl")
    public suspend fun inProgressRefreshJobId(`value`: Output<String>) {
        this.inProgressRefreshJobId = value
    }

    /**
     * @param value Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
     */
    @JvmName("ncmvugoeyeabstqg")
    public suspend fun lastCompletedRefreshJobTimeInUTC(`value`: Output<String>) {
        this.lastCompletedRefreshJobTimeInUTC = value
    }

    /**
     * @param value Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
     */
    @JvmName("impplglmjxlnaelh")
    public suspend fun lastJob(`value`: Output<String>) {
        this.lastJob = value
    }

    /**
     * @param value Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
     */
    @JvmName("fglvkslxqipdacrp")
    public suspend fun errorManifestFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorManifestFile = mapped
    }

    /**
     * @param value If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
     */
    @JvmName("pnkctegskdcnujma")
    public suspend fun inProgressRefreshJobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inProgressRefreshJobId = mapped
    }

    /**
     * @param value Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
     */
    @JvmName("imwpkgfwwltreadl")
    public suspend fun lastCompletedRefreshJobTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastCompletedRefreshJobTimeInUTC = mapped
    }

    /**
     * @param value Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
     */
    @JvmName("qcbidnqfsckhenyg")
    public suspend fun lastJob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastJob = mapped
    }

    internal fun build(): RefreshDetailsArgs = RefreshDetailsArgs(
        errorManifestFile = errorManifestFile,
        inProgressRefreshJobId = inProgressRefreshJobId,
        lastCompletedRefreshJobTimeInUTC = lastCompletedRefreshJobTimeInUTC,
        lastJob = lastJob,
    )
}
