@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.RoleSinkInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Compute role against which events will be raised.
 * @property roleId Compute role ID.
 */
public data class RoleSinkInfoArgs(
    public val roleId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.RoleSinkInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.RoleSinkInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.RoleSinkInfoArgs.builder()
            .roleId(roleId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleSinkInfoArgs].
 */
@PulumiTagMarker
public class RoleSinkInfoArgsBuilder internal constructor() {
    private var roleId: Output<String>? = null

    /**
     * @param value Compute role ID.
     */
    @JvmName("emjnvreiwlaqelnb")
    public suspend fun roleId(`value`: Output<String>) {
        this.roleId = value
    }

    /**
     * @param value Compute role ID.
     */
    @JvmName("gxyonyrvsxfjchxi")
    public suspend fun roleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleId = mapped
    }

    internal fun build(): RoleSinkInfoArgs = RoleSinkInfoArgs(
        roleId = roleId ?: throw PulumiNullFieldException("roleId"),
    )
}
