@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.SymmetricKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Symmetric key for authentication.
 * @property connectionString Connection string based on the symmetric key.
 */
public data class SymmetricKeyArgs(
    public val connectionString: Output<AsymmetricEncryptedSecretArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.SymmetricKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.SymmetricKeyArgs =
        com.pulumi.azurenative.databoxedge.inputs.SymmetricKeyArgs.builder()
            .connectionString(
                connectionString?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SymmetricKeyArgs].
 */
@PulumiTagMarker
public class SymmetricKeyArgsBuilder internal constructor() {
    private var connectionString: Output<AsymmetricEncryptedSecretArgs>? = null

    /**
     * @param value Connection string based on the symmetric key.
     */
    @JvmName("bdbyuneehbwacdtt")
    public suspend fun connectionString(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.connectionString = value
    }

    /**
     * @param value Connection string based on the symmetric key.
     */
    @JvmName("swpmyuuvlltrdltt")
    public suspend fun connectionString(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param argument Connection string based on the symmetric key.
     */
    @JvmName("pkiveagrqrmolpca")
    public suspend fun connectionString(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionString = mapped
    }

    internal fun build(): SymmetricKeyArgs = SymmetricKeyArgs(
        connectionString = connectionString,
    )
}
