@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure container mapping of the endpoint.
 * @property containerName Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
 * @property dataFormat Storage format used for the file represented by the share.
 * @property storageAccountCredentialId ID of the storage account credential used to access storage.
 */
public data class AzureContainerInfoResponse(
    public val containerName: String,
    public val dataFormat: String,
    public val storageAccountCredentialId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.AzureContainerInfoResponse): AzureContainerInfoResponse = AzureContainerInfoResponse(
            containerName = javaType.containerName(),
            dataFormat = javaType.dataFormat(),
            storageAccountCredentialId = javaType.storageAccountCredentialId(),
        )
    }
}
