@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cni configuration
 * @property podSubnet Pod Subnet
 * @property serviceSubnet Service subnet
 * @property type Cni type
 * @property version Cni version
 */
public data class CniConfigResponse(
    public val podSubnet: String,
    public val serviceSubnet: String,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.CniConfigResponse): CniConfigResponse = CniConfigResponse(
            podSubnet = javaType.podSubnet(),
            serviceSubnet = javaType.serviceSubnet(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
