@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Arc Addon.
 * @property hostPlatform Host OS supported by the Arc addon.
 * @property hostPlatformType Platform where the runtime is hosted.
 * @property id The path ID that uniquely identifies the object.
 * @property kind Addon type.
 * Expected value is 'ArcForKubernetes'.
 * @property name The object name.
 * @property provisioningState Addon Provisioning State
 * @property resourceGroupName Arc resource group name
 * @property resourceLocation Arc resource location
 * @property resourceName Arc resource Name
 * @property subscriptionId Arc resource subscription Id
 * @property systemData Metadata pertaining to creation and last modification of Addon
 * @property type The hierarchical type of the object.
 * @property version Arc resource version
 */
public data class GetArcAddonResult(
    public val hostPlatform: String,
    public val hostPlatformType: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceGroupName: String,
    public val resourceLocation: String,
    public val resourceName: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetArcAddonResult): GetArcAddonResult = GetArcAddonResult(
            hostPlatform = javaType.hostPlatform(),
            hostPlatformType = javaType.hostPlatformType(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGroupName = javaType.resourceGroupName(),
            resourceLocation = javaType.resourceLocation(),
            resourceName = javaType.resourceName(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
