@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
 * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
 * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
 * @property edgeProfile Edge Profile of the resource
 * @property id The path ID that uniquely identifies the object.
 * @property kind Role type.
 * Expected value is 'CloudEdgeManagement'.
 * @property localManagementStatus Local Edge Management Status
 * @property name The object name.
 * @property roleStatus Role status.
 * @property systemData Metadata pertaining to creation and last modification of Role
 * @property type The hierarchical type of the object.
 */
public data class GetCloudEdgeManagementRoleResult(
    public val edgeProfile: EdgeProfileResponse,
    public val id: String,
    public val kind: String,
    public val localManagementStatus: String,
    public val name: String,
    public val roleStatus: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetCloudEdgeManagementRoleResult): GetCloudEdgeManagementRoleResult = GetCloudEdgeManagementRoleResult(
            edgeProfile = javaType.edgeProfile().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            kind = javaType.kind(),
            localManagementStatus = javaType.localManagementStatus(),
            name = javaType.name(),
            roleStatus = javaType.roleStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
