@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MEC role.
 * @property connectionString Activation key of the MEC.
 * @property controllerEndpoint Controller Endpoint.
 * @property id The path ID that uniquely identifies the object.
 * @property kind Role type.
 * Expected value is 'MEC'.
 * @property name The object name.
 * @property resourceUniqueId Unique Id of the Resource.
 * @property roleStatus Role status.
 * @property systemData Metadata pertaining to creation and last modification of Role
 * @property type The hierarchical type of the object.
 */
public data class GetMECRoleResult(
    public val connectionString: AsymmetricEncryptedSecretResponse? = null,
    public val controllerEndpoint: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val resourceUniqueId: String? = null,
    public val roleStatus: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetMECRoleResult): GetMECRoleResult = GetMECRoleResult(
            connectionString = javaType.connectionString().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            controllerEndpoint = javaType.controllerEndpoint().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            resourceUniqueId = javaType.resourceUniqueId().map({ args0 -> args0 }).orElse(null),
            roleStatus = javaType.roleStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
