@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The metric setting details for the role
 * @property id The path ID that uniquely identifies the object.
 * @property metricConfigurations The metrics configuration details
 * @property name The object name.
 * @property systemData Metadata pertaining to creation and last modification of MonitoringConfiguration
 * @property type The hierarchical type of the object.
 */
public data class GetMonitoringConfigResult(
    public val id: String,
    public val metricConfigurations: List<MetricConfigurationResponse>,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetMonitoringConfigResult): GetMonitoringConfigResult = GetMonitoringConfigResult(
            id = javaType.id(),
            metricConfigurations = javaType.metricConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
