@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The storage account credential.
 * @property accountKey Encrypted storage key.
 * @property accountType Type of storage accessed on the storage account.
 * @property alias Alias for the storage account.
 * @property blobDomainName Blob end point for private clouds.
 * @property connectionString Connection string for the storage account. Use this string if username and account key are not specified.
 * @property id The path ID that uniquely identifies the object.
 * @property name The object name.
 * @property sslStatus Signifies whether SSL needs to be enabled or not.
 * @property storageAccountId Id of the storage account.
 * @property systemData Metadata pertaining to creation and last modification of StorageAccountCredential
 * @property type The hierarchical type of the object.
 * @property userName Username for the storage account.
 */
public data class GetStorageAccountCredentialResult(
    public val accountKey: AsymmetricEncryptedSecretResponse? = null,
    public val accountType: String,
    public val alias: String,
    public val blobDomainName: String? = null,
    public val connectionString: String? = null,
    public val id: String,
    public val name: String,
    public val sslStatus: String,
    public val storageAccountId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetStorageAccountCredentialResult): GetStorageAccountCredentialResult = GetStorageAccountCredentialResult(
            accountKey = javaType.accountKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accountType = javaType.accountType(),
            alias = javaType.alias(),
            blobDomainName = javaType.blobDomainName().map({ args0 -> args0 }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            sslStatus = javaType.sslStatus(),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
