@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents a Storage Account on the  Data Box Edge/Gateway device.
 * @property blobEndpoint BlobEndpoint of Storage Account
 * @property containerCount The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
 * @property dataPolicy Data policy of the storage Account.
 * @property description Description for the storage Account.
 * @property id The path ID that uniquely identifies the object.
 * @property name The object name.
 * @property storageAccountCredentialId Storage Account Credential Id
 * @property storageAccountStatus Current status of the storage account
 * @property systemData Metadata pertaining to creation and last modification of StorageAccount
 * @property type The hierarchical type of the object.
 */
public data class GetStorageAccountResult(
    public val blobEndpoint: String,
    public val containerCount: Int,
    public val dataPolicy: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val storageAccountCredentialId: String? = null,
    public val storageAccountStatus: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetStorageAccountResult): GetStorageAccountResult = GetStorageAccountResult(
            blobEndpoint = javaType.blobEndpoint(),
            containerCount = javaType.containerCount(),
            dataPolicy = javaType.dataPolicy(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            storageAccountCredentialId = javaType.storageAccountCredentialId().map({ args0 ->
                args0
            }).orElse(null),
            storageAccountStatus = javaType.storageAccountStatus().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
