@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
 * @property encryptedPassword The password details.
 * @property id The path ID that uniquely identifies the object.
 * @property name The object name.
 * @property shareAccessRights List of shares that the user has rights on. This field should not be specified during user creation.
 * @property systemData Metadata pertaining to creation and last modification of User
 * @property type The hierarchical type of the object.
 * @property userType Type of the user.
 */
public data class GetUserResult(
    public val encryptedPassword: AsymmetricEncryptedSecretResponse? = null,
    public val id: String,
    public val name: String,
    public val shareAccessRights: List<ShareAccessRightResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val userType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetUserResult): GetUserResult = GetUserResult(
            encryptedPassword = javaType.encryptedPassword().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            shareAccessRights = javaType.shareAccessRights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.ShareAccessRightResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            userType = javaType.userType(),
        )
    }
}
