@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image repository credential.
 * @property imageRepositoryUrl Image repository url (e.g.: mcr.microsoft.com).
 * @property password Repository user password.
 * @property userName Repository user name.
 */
public data class ImageRepositoryCredentialResponse(
    public val imageRepositoryUrl: String,
    public val password: AsymmetricEncryptedSecretResponse? = null,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ImageRepositoryCredentialResponse): ImageRepositoryCredentialResponse = ImageRepositoryCredentialResponse(
            imageRepositoryUrl = javaType.imageRepositoryUrl(),
            password = javaType.password().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userName = javaType.userName(),
        )
    }
}
