@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping IoT Role if specified.
 * @property imageName Name of the IoT edge agent image.
 * @property imageRepository Image repository details.
 * @property tag Image Tag.
 */
public data class IoTEdgeAgentInfoResponse(
    public val imageName: String,
    public val imageRepository: ImageRepositoryCredentialResponse? = null,
    public val tag: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.IoTEdgeAgentInfoResponse): IoTEdgeAgentInfoResponse = IoTEdgeAgentInfoResponse(
            imageName = javaType.imageName(),
            imageRepository = javaType.imageRepository().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.ImageRepositoryCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tag = javaType.tag(),
        )
    }
}
