@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Kubernetes cluster configuration
 * @property etcdInfo Etcd configuration
 * @property nodes Kubernetes cluster nodes
 * @property version Kubernetes cluster version
 */
public data class KubernetesClusterInfoResponse(
    public val etcdInfo: EtcdInfoResponse,
    public val nodes: List<NodeInfoResponse>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesClusterInfoResponse): KubernetesClusterInfoResponse = KubernetesClusterInfoResponse(
            etcdInfo = javaType.etcdInfo().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.EtcdInfoResponse.Companion.toKotlin(args0)
            }),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.NodeInfoResponse.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version(),
        )
    }
}
