@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kubernetes node IP configuration
 * @property ipAddress IP address of the Kubernetes node.
 * @property port Port of the Kubernetes node.
 */
public data class KubernetesIPConfigurationResponse(
    public val ipAddress: String? = null,
    public val port: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesIPConfigurationResponse): KubernetesIPConfigurationResponse = KubernetesIPConfigurationResponse(
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
        )
    }
}
