@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Kubernetes role compute resource
 * @property memoryInBytes Memory in bytes
 * @property processorCount Processor count
 * @property vmProfile VM profile
 */
public data class KubernetesRoleComputeResponse(
    public val memoryInBytes: Double,
    public val processorCount: Int,
    public val vmProfile: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesRoleComputeResponse): KubernetesRoleComputeResponse = KubernetesRoleComputeResponse(
            memoryInBytes = javaType.memoryInBytes(),
            processorCount = javaType.processorCount(),
            vmProfile = javaType.vmProfile(),
        )
    }
}
