@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Suppress

/**
 * Kubernetes role network resource
 * @property cniConfig Cni configuration
 * @property loadBalancerConfig Load balancer configuration
 */
public data class KubernetesRoleNetworkResponse(
    public val cniConfig: CniConfigResponse,
    public val loadBalancerConfig: LoadBalancerConfigResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesRoleNetworkResponse): KubernetesRoleNetworkResponse = KubernetesRoleNetworkResponse(
            cniConfig = javaType.cniConfig().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.CniConfigResponse.Companion.toKotlin(args0)
            }),
            loadBalancerConfig = javaType.loadBalancerConfig().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.LoadBalancerConfigResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
