@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Kubernetes role storage resource
 * @property endpoints Mount points of shares in role(s).
 * @property storageClasses Kubernetes storage class info.
 */
public data class KubernetesRoleStorageResponse(
    public val endpoints: List<MountPointMapResponse>? = null,
    public val storageClasses: List<KubernetesRoleStorageClassInfoResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesRoleStorageResponse): KubernetesRoleStorageResponse = KubernetesRoleStorageResponse(
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse.Companion.toKotlin(args0)
                })
            }),
            storageClasses = javaType.storageClasses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleStorageClassInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
