@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Metric configuration.
 * @property counterSets Host name for the IoT hub associated to the device.
 * @property mdmAccount The MDM account to which the counters should be pushed.
 * @property metricNameSpace The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
 * @property resourceId The Resource ID on which the metrics should be pushed.
 */
public data class MetricConfigurationResponse(
    public val counterSets: List<MetricCounterSetResponse>,
    public val mdmAccount: String? = null,
    public val metricNameSpace: String? = null,
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.MetricConfigurationResponse): MetricConfigurationResponse = MetricConfigurationResponse(
            counterSets = javaType.counterSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricCounterSetResponse.Companion.toKotlin(args0)
                })
            }),
            mdmAccount = javaType.mdmAccount().map({ args0 -> args0 }).orElse(null),
            metricNameSpace = javaType.metricNameSpace().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId(),
        )
    }
}
