@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The share mount point.
 * @property mountPoint Mount point for the share.
 * @property mountType Mounting type.
 * @property roleId ID of the role to which share is mounted.
 * @property roleType Role type.
 * @property shareId ID of the share mounted to the role VM.
 */
public data class MountPointMapResponse(
    public val mountPoint: String,
    public val mountType: String,
    public val roleId: String,
    public val roleType: String,
    public val shareId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.MountPointMapResponse): MountPointMapResponse = MountPointMapResponse(
            mountPoint = javaType.mountPoint(),
            mountType = javaType.mountType(),
            roleId = javaType.roleId(),
            roleType = javaType.roleType(),
            shareId = javaType.shareId(),
        )
    }
}
