@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Kubernetes node info
 * @property ipConfiguration IP Configuration of the Kubernetes node.
 * @property name Node name.
 * @property type Node type - Master/Worker
 */
public data class NodeInfoResponse(
    public val ipConfiguration: List<KubernetesIPConfigurationResponse>? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.NodeInfoResponse): NodeInfoResponse = NodeInfoResponse(
            ipConfiguration = javaType.ipConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
