@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a single status change.
 * @property additionalOrderDetails Dictionary to hold generic information which is not stored
 * by the already existing properties
 * @property comments Comments related to this status change.
 * @property status Status of the order as per the allowed status types.
 * @property trackingInformation Tracking information related to the state in the ordering flow
 * @property updateDateTime Time of status update.
 */
public data class OrderStatusResponse(
    public val additionalOrderDetails: Map<String, String>,
    public val comments: String? = null,
    public val status: String,
    public val trackingInformation: TrackingInfoResponse,
    public val updateDateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.OrderStatusResponse): OrderStatusResponse = OrderStatusResponse(
            additionalOrderDetails = javaType.additionalOrderDetails().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            comments = javaType.comments().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            trackingInformation = javaType.trackingInformation().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.TrackingInfoResponse.Companion.toKotlin(args0)
            }),
            updateDateTime = javaType.updateDateTime(),
        )
    }
}
