@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Periodic timer event source.
 * @property schedule Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
 * @property startTime The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
 * @property topic Topic where periodic events are published to IoT device.
 */
public data class PeriodicTimerSourceInfoResponse(
    public val schedule: String,
    public val startTime: String,
    public val topic: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.PeriodicTimerSourceInfoResponse): PeriodicTimerSourceInfoResponse = PeriodicTimerSourceInfoResponse(
            schedule = javaType.schedule(),
            startTime = javaType.startTime(),
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
        )
    }
}
