@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Fields for tracking refresh job on the share or container.
 * @property errorManifestFile Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.
 * @property inProgressRefreshJobId If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
 * @property lastCompletedRefreshJobTimeInUTC Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.
 * @property lastJob Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.
 */
public data class RefreshDetailsResponse(
    public val errorManifestFile: String? = null,
    public val inProgressRefreshJobId: String? = null,
    public val lastCompletedRefreshJobTimeInUTC: String? = null,
    public val lastJob: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.RefreshDetailsResponse): RefreshDetailsResponse = RefreshDetailsResponse(
            errorManifestFile = javaType.errorManifestFile().map({ args0 -> args0 }).orElse(null),
            inProgressRefreshJobId = javaType.inProgressRefreshJobId().map({ args0 -> args0 }).orElse(null),
            lastCompletedRefreshJobTimeInUTC = javaType.lastCompletedRefreshJobTimeInUTC().map({ args0 ->
                args0
            }).orElse(null),
            lastJob = javaType.lastJob().map({ args0 -> args0 }).orElse(null),
        )
    }
}
