@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Fields for tracking resource move
 * @property operationInProgress Denotes whether move operation is in progress
 * @property operationInProgressLockTimeoutInUTC Denotes the timeout of the operation to finish
 */
public data class ResourceMoveDetailsResponse(
    public val operationInProgress: String? = null,
    public val operationInProgressLockTimeoutInUTC: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ResourceMoveDetailsResponse): ResourceMoveDetailsResponse = ResourceMoveDetailsResponse(
            operationInProgress = javaType.operationInProgress().map({ args0 -> args0 }).orElse(null),
            operationInProgressLockTimeoutInUTC = javaType.operationInProgressLockTimeoutInUTC().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
