@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Holds device secret either as a KeyVault reference or as an encrypted value.
 * @property encryptedSecret Encrypted (using device public key) secret value.
 * @property keyVaultId Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
 */
public data class SecretResponse(
    public val encryptedSecret: AsymmetricEncryptedSecretResponse? = null,
    public val keyVaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.SecretResponse): SecretResponse = SecretResponse(
            encryptedSecret = javaType.encryptedSecret().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
