@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.kotlin.outputs.AccessConnectorPropertiesResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.databricks.kotlin.outputs.AccessConnectorPropertiesResponse.Companion.toKotlin as accessConnectorPropertiesResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AccessConnector].
 */
@PulumiTagMarker
public class AccessConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessConnectorArgs = AccessConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessConnectorArgsBuilder.() -> Unit) {
        val builder = AccessConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessConnector {
        val builtJavaResource =
            com.pulumi.azurenative.databricks.AccessConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessConnector(builtJavaResource)
    }
}

/**
 * Information about azure databricks accessConnector.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2024-05-01.
 * ## Example Usage
 * ### Create an azure databricks accessConnector with SystemAssigned Identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessConnector = new AzureNative.Databricks.AccessConnector("accessConnector", new()
 *     {
 *         ConnectorName = "myAccessConnector",
 *         Location = "westus",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewAccessConnector(ctx, "accessConnector", &databricks.AccessConnectorArgs{
 * 			ConnectorName:     pulumi.String("myAccessConnector"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.AccessConnector;
 * import com.pulumi.azurenative.databricks.AccessConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessConnector = new AccessConnector("accessConnector", AccessConnectorArgs.builder()
 *             .connectorName("myAccessConnector")
 *             .location("westus")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an azure databricks accessConnector with UserAssigned Identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessConnector = new AzureNative.Databricks.AccessConnector("accessConnector", new()
 *     {
 *         ConnectorName = "myAccessConnector",
 *         Location = "westus",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewAccessConnector(ctx, "accessConnector", &databricks.AccessConnectorArgs{
 * 			ConnectorName:     pulumi.String("myAccessConnector"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.AccessConnector;
 * import com.pulumi.azurenative.databricks.AccessConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessConnector = new AccessConnector("accessConnector", AccessConnectorArgs.builder()
 *             .connectorName("myAccessConnector")
 *             .location("westus")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databricks:AccessConnector myAccessConnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/accessConnectors/{connectorName}
 * ```
 */
public class AccessConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.databricks.AccessConnector,
) : KotlinCustomResource(javaResource, AccessConnectorMapper) {
    /**
     * Managed service identity (system assigned and/or user assigned identities)
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Databricks accessConnector properties
     */
    public val properties: Output<AccessConnectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                accessConnectorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessConnectorMapper : ResourceMapper<AccessConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databricks.AccessConnector::class == javaResource::class

    override fun map(javaResource: Resource): AccessConnector = AccessConnector(
        javaResource as
            com.pulumi.azurenative.databricks.AccessConnector,
    )
}

/**
 * @see [AccessConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessConnector].
 */
public suspend fun accessConnector(
    name: String,
    block: suspend AccessConnectorResourceBuilder.() -> Unit,
): AccessConnector {
    val builder = AccessConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessConnector(name: String): AccessConnector {
    val builder = AccessConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
