@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
 */
public enum class KeySource(
    public val javaValue: com.pulumi.azurenative.databricks.enums.KeySource,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.enums.KeySource> {
    Default(com.pulumi.azurenative.databricks.enums.KeySource.Default),
    Microsoft_Keyvault(com.pulumi.azurenative.databricks.enums.KeySource.Microsoft_Keyvault),
    ;

    override fun toJava(): com.pulumi.azurenative.databricks.enums.KeySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.enums.KeySource): KeySource =
            KeySource.values().first { it.javaValue == javaType }
    }
}
