@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.databricks.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.databricks.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.databricks.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.databricks.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
