@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.GetAccessConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectorName The name of the azure databricks accessConnector.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccessConnectorPlainArgs(
    public val connectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.GetAccessConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.GetAccessConnectorPlainArgs =
        com.pulumi.azurenative.databricks.inputs.GetAccessConnectorPlainArgs.builder()
            .connectorName(connectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetAccessConnectorPlainArgsBuilder internal constructor() {
    private var connectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the azure databricks accessConnector.
     */
    @JvmName("arltojlksoljwgnq")
    public suspend fun connectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jlixerlkvmexwqfi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessConnectorPlainArgs = GetAccessConnectorPlainArgs(
        connectorName = connectorName ?: throw PulumiNullFieldException("connectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
