@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.PrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a private endpoint connection
 * @property groupIds GroupIds from the private link service resource.
 * @property privateLinkServiceConnectionState Private endpoint connection state
 */
public data class PrivateEndpointConnectionPropertiesArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.PrivateEndpointConnectionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.PrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.databricks.inputs.PrivateEndpointConnectionPropertiesArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("kbintkanimajbbqb")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("efojtuvwbnbursuc")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("ffnmvsppsmfgecyp")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value Private endpoint connection state
     */
    @JvmName("oulojcqlmlefabwk")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("htloxhphuomekrbv")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("eniyegfsirbgnqga")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value Private endpoint connection state
     */
    @JvmName("exdijtliomhngwek")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Private endpoint connection state
     */
    @JvmName("rqxxqyjgbqcfgwjy")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesArgs =
        PrivateEndpointConnectionPropertiesArgs(
            groupIds = groupIds,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState ?: throw
                PulumiNullFieldException("privateLinkServiceConnectionState"),
        )
}
