@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
 * @property id The Id of the remote virtual network.
 */
public data class VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs =
        com.pulumi.azurenative.databricks.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The Id of the remote virtual network.
     */
    @JvmName("jhlxmvggumwnnyur")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Id of the remote virtual network.
     */
    @JvmName("ctcintggbmofaxxx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs =
        VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs(
            id = id,
        )
}
