@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.Suppress

/**
 * Encryption entities for databricks workspace resource.
 * @property managedDisk Encryption properties for the databricks managed disks.
 * @property managedServices Encryption properties for the databricks managed services.
 */
public data class EncryptionEntitiesDefinitionResponse(
    public val managedDisk: ManagedDiskEncryptionResponse? = null,
    public val managedServices: EncryptionV2Response? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.EncryptionEntitiesDefinitionResponse): EncryptionEntitiesDefinitionResponse = EncryptionEntitiesDefinitionResponse(
            managedDisk = javaType.managedDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.ManagedDiskEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedServices = javaType.managedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.EncryptionV2Response.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
