@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about workspace.
 * @property authorizations The workspace provider authorizations.
 * @property createdBy Indicates the Object ID, PUID and Application ID of entity that created the workspace.
 * @property createdDateTime Specifies the date and time when the workspace is created.
 * @property diskEncryptionSetId The resource Id of the managed disk encryption set.
 * @property encryption Encryption properties for databricks workspace
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property managedDiskIdentity The details of Managed Identity of Disk Encryption Set used for Managed Disk Encryption
 * @property managedResourceGroupId The managed resource group Id.
 * @property name The name of the resource
 * @property parameters The workspace's custom parameters.
 * @property privateEndpointConnections Private endpoint connections created on the workspace
 * @property provisioningState The workspace provisioning state.
 * @property publicNetworkAccess The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
 * @property requiredNsgRules Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
 * @property sku The SKU of the resource.
 * @property storageAccountIdentity The details of Managed Identity of Storage Account
 * @property systemData The system metadata relating to this resource
 * @property tags Resource tags.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 * @property uiDefinitionUri The blob URI where the UI definition file is located.
 * @property updatedBy Indicates the Object ID, PUID and Application ID of entity that last updated the workspace.
 * @property workspaceId The unique identifier of the databricks workspace in databricks control plane.
 * @property workspaceUrl The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
 */
public data class GetWorkspaceResult(
    public val authorizations: List<WorkspaceProviderAuthorizationResponse>? = null,
    public val createdBy: CreatedByResponse? = null,
    public val createdDateTime: String,
    public val diskEncryptionSetId: String,
    public val encryption: WorkspacePropertiesResponseEncryption? = null,
    public val id: String,
    public val location: String,
    public val managedDiskIdentity: ManagedIdentityConfigurationResponse? = null,
    public val managedResourceGroupId: String,
    public val name: String,
    public val parameters: WorkspaceCustomParametersResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val requiredNsgRules: String? = null,
    public val sku: SkuResponse? = null,
    public val storageAccountIdentity: ManagedIdentityConfigurationResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uiDefinitionUri: String? = null,
    public val updatedBy: CreatedByResponse? = null,
    public val workspaceId: String,
    public val workspaceUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            authorizations = javaType.authorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceProviderAuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.CreatedByResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdDateTime = javaType.createdDateTime(),
            diskEncryptionSetId = javaType.diskEncryptionSetId(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspacePropertiesResponseEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            managedDiskIdentity = javaType.managedDiskIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.ManagedIdentityConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedResourceGroupId = javaType.managedResourceGroupId(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            requiredNsgRules = javaType.requiredNsgRules().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountIdentity = javaType.storageAccountIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.ManagedIdentityConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uiDefinitionUri = javaType.uiDefinitionUri().map({ args0 -> args0 }).orElse(null),
            updatedBy = javaType.updatedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.CreatedByResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaceId = javaType.workspaceId(),
            workspaceUrl = javaType.workspaceUrl(),
        )
    }
}
