@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The object that contains details of encryption used on the workspace.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
 * @property keyVaultProperties Key Vault input properties for encryption.
 * @property rotationToLatestKeyVersionEnabled Indicate whether the latest key version should be automatically used for Managed Disk Encryption.
 */
public data class ManagedDiskEncryptionResponse(
    public val keySource: String,
    public val keyVaultProperties: ManagedDiskEncryptionResponseKeyVaultProperties,
    public val rotationToLatestKeyVersionEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.ManagedDiskEncryptionResponse): ManagedDiskEncryptionResponse = ManagedDiskEncryptionResponse(
            keySource = javaType.keySource(),
            keyVaultProperties = javaType.keyVaultProperties().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.ManagedDiskEncryptionResponseKeyVaultProperties.Companion.toKotlin(args0)
            }),
            rotationToLatestKeyVersionEnabled = javaType.rotationToLatestKeyVersionEnabled().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
