@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Managed Identity details for storage account.
 * @property principalId The objectId of the Managed Identity that is linked to the Managed Storage account.
 * @property tenantId The tenant Id where the Managed Identity is created.
 * @property type The type of Identity created. It can be either SystemAssigned or UserAssigned.
 */
public data class ManagedIdentityConfigurationResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.ManagedIdentityConfigurationResponse): ManagedIdentityConfigurationResponse = ManagedIdentityConfigurationResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
