@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private endpoint connection of a workspace
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties The private endpoint connection properties.
 * @property type The resource type.
 */
public data class PrivateEndpointConnectionResponse(
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.PrivateEndpointConnectionResponse): PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
