@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU for the resource.
 * @property name The SKU name.
 * @property tier The SKU tier.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
