@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object that contains details of encryption used on the workspace.
 * @property type The type of variable that this is
 * @property value The value which should be used for this field.
 */
public data class WorkspaceEncryptionParameterResponse(
    public val type: String,
    public val `value`: EncryptionResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.WorkspaceEncryptionParameterResponse): WorkspaceEncryptionParameterResponse = WorkspaceEncryptionParameterResponse(
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
