@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Data Catalog.
 * @property admins Azure data catalog admin list.
 * @property enableAutomaticUnitAdjustment Automatic unit adjustment enabled or not.
 * @property etag Resource etag
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property sku Azure data catalog SKU.
 * @property successfullyProvisioned Azure data catalog provision status.
 * @property tags Resource tags
 * @property type Resource type
 * @property units Azure data catalog units.
 * @property users Azure data catalog user list.
 */
public data class GetADCCatalogResult(
    public val admins: List<PrincipalsResponse>? = null,
    public val enableAutomaticUnitAdjustment: Boolean? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val sku: String? = null,
    public val successfullyProvisioned: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val units: Int? = null,
    public val users: List<PrincipalsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datacatalog.outputs.GetADCCatalogResult): GetADCCatalogResult = GetADCCatalogResult(
            admins = javaType.admins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datacatalog.kotlin.outputs.PrincipalsResponse.Companion.toKotlin(args0)
                })
            }),
            enableAutomaticUnitAdjustment = javaType.enableAutomaticUnitAdjustment().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            successfullyProvisioned = javaType.successfullyProvisioned().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            units = javaType.units().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datacatalog.kotlin.outputs.PrincipalsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
